function [subsetclass] = subsetmatmkr(dir_tmp1,dir_tmp2)
%A little test function that will allow me to make mat files for generating
%synsubsets.  Used for automating the use of synsubset.
%Synatax:   [data] = join_verts();
%Input:     dir_tmp1 = the directory where the data is coming from
%           dir_tmp2 = the directory where the data is going to
%           Note: both must be entered for the prompts to not show up.
%Output:    subsetclass = information regarding the classification of a
%               particlular subclass.

if nargin<2
    dir_tmp1 = uigetdir2('','Open Original Data Location');    %get the directory
    dir_tmp2 = uigetdir3('','Open Output Data Location');    %get the directory
end
%now get the directory structures and the names of the directories
% dir_struct1 = dir(dir_tmp1);  %grab the directory information
% idx = [dir_struct1.isdir];   %grab all of the isdir numbers
% names = {dir_struct1.name};   %grab the all of the names in the root
% dirnames1 = names(idx);
dir_struct2 = dir(dir_tmp2);  %grab the directory information
idx2 = [dir_struct2.isdir];   %grab all of the isdir numbers
names2 = {dir_struct2.name};   %grab the all of the names in the root
dirnames2 = names2(idx2);
prepost = [];
%Now cycle through the directory names and try to find a match, if you do
%then proceed to finding the files
for i = 3:size(dirnames2,2)
    %parse the output directory string
    stridx = isstrprop(dirnames2{i},'punct');
    stridx = find(stridx==1);   
    dirstr = dirnames2{i}(stridx(1)+1:end);     %grab the directory string for matching
    filestr = dirnames2{i}(1:stridx(1)-1);      %grab the file matching string, if needed
    %Which prepost parameter
    prepost = str2double(response_box('title','Prepost for Class:','caption',dirnames2{i},'input',num2str(prepost),'position','center'));
    if isnan(prepost) %no input
        prepost = [];  %is empty
    end
    %special cases---------------------------------
    switch filestr
        case 'Vg1'  %transformer
            filestr = 'PSD-Syn_VGlut1-12';
            inh = 1;
        case 'Vg12'
            filestr = 'PSD-Syn_VGlut1&2';
            inh = 1;
        case 'Vg2'
            filestr = 'PSD-Syn_VGlut2-12';
            inh = 1;
        otherwise
            inh = 0;
    end
    %special cases---------------------------------
    try     %if there is an error at any point, give command to the user and let them pick the matching file
        %try to grab the files from the desired directory
        dir_struct1 = dir([dir_tmp1,filesep,dirstr]);
        if isempty(prepost)     %no prepost, we will need to pull the properties file
            if inh
                [file1] = pullfile2(dir_struct1,filestr,'prop');  %pull the subtype vertices file
                [file2] = pullfile(dir_struct1,'Geph','vert');  %pull the origin vertices file
                [file3] = pullfile(dir_struct1,'VGat','vert');  %pull the termini vertices file
            else
                [file1] = pullfile(dir_struct1,filestr,'prop');
                [file2] = pullfile(dir_struct1,'PSD95','vert');  %pull the origin vertices file
                [file3] = pullfile(dir_struct1,'SynXP','vert');  %pull the termini vertices file
            end
        else
            if inh
                [file1] = pullfile2(dir_struct1,filestr,'vert');
                [file2] = pullfile(dir_struct1,'Geph','vert');  %pull the origin vertices file
                [file3] = pullfile(dir_struct1,'VGat','vert');  %pull the termini vertices file
            else
                [file1] = pullfile(dir_struct1,filestr,'vert');  %pull the subtype vertices file
                [file2] = pullfile(dir_struct1,'PSD95','vert');  %pull the origin vertices file
                [file3] = pullfile(dir_struct1,'SynXP','vert');  %pull the termini vertices file
            end
        end
        dir1 = [dir_tmp1,filesep,dirstr,filesep];   %the directory string
    catch   %let the user pick, we are assuming everything is in the same directory
        if isempty(prepost)
            [file1,dir1] = uigetfile2({'*.csv','Text files (*.csv)';'*.*','All Files';},...
                ['Open properties file for ',dirnames2{i}],'Multiselect','off');
        else
            [file1,dir1] = uigetfile2({'*.csv','Text files (*.csv)';'*.*','All Files';},...
                ['Open verticies file for ',dirnames2{i}],'Multiselect','off');
            [file2,dir1] = uigetfile2({'*.csv','Text files (*.csv)';'*.*','All Files';},...
                ['Open origin verticies file for ',dirnames2{i}],'Multiselect','off');
            [file3,dir1] = uigetfile2({'*.csv','Text files (*.csv)';'*.*','All Files';},...
                ['Open termini verticies file for ',dirnames2{i}],'Multiselect','off');
        end
    end
    %put into save into structure
    subsetclass(i-2).prepost = prepost;
    subsetclass(i-2).datadir = dir1;
    subsetclass(i-2).dirout = [dir_tmp2,filesep,dirnames2{i}];
    if isempty(prepost)
        subsetclass(i-2).files = {file1};
    else
        subsetclass(i-2).files = {file1,file2,file3};
    end
end
        
%save out the new files and new path
save([dir_tmp1,filesep,'subsetclass.mat'],'subsetclass');

%--------------------------------------------------------------------------
%subfunction pull properties file
function [filename] = pullfile(dir_struct,matchstr,propstr)

for i = 3:size(dir_struct,1)    %go through the 
    idx(i-2) = dir_struct(i).isdir;     %pull the isdir info
    names{i-2} = dir_struct(i).name;     %pull the file and dir names
end

%get the files
list = names(~idx);

for j = 1:size(list,2);
    %the only files we care about are the flat rotated vertices and the properties for now
    stridx = isstrprop(list{j},'punct');
    stridx = find(stridx==1);   %the second '_' is the one
    if strcmp(propstr,list{j}(1:stridx(1)-1)) %first step
        if strcmp(list{j}(stridx(1)+1:stridx(2)-1),matchstr)    %the match we are looking for
            filename = list{j};
        end
    end
end
%--------------------------------------------------------------------------
%subfunction pull properties file for long file names with lots of
%punctuations
function [filename] = pullfile2(dir_struct,matchstr,propstr)

switch propstr      %different ways of pulling the strings
    case 'vert'
        parsetype = 1;
    otherwise
        parsetype = 0;
end

for i = 3:size(dir_struct,1)    %go through the 
    idx(i-2) = dir_struct(i).isdir;     %pull the isdir info
    names{i-2} = dir_struct(i).name;     %pull the file and dir names
end

%get the files
list = names(~idx);

for j = 1:size(list,2);
    %the only files we care about are the flat rotated vertices and the properties for now
    stridx = isstrprop(list{j},'punct');
    stridx = find(stridx==1);   %the second '_' is the one
    if strcmp(propstr,list{j}(1:stridx(1)-1)) %first step
        if parsetype
            if strcmp(list{j}(stridx(1)+1:stridx(end-1)-1),matchstr)    %the match we are looking for
                filename = list{j};
            end
        else
            if strcmp(list{j}(stridx(1)+1:stridx(end)-1),matchstr)    %the match we are looking for
                filename = list{j};
            end
        end
    end
end